﻿Imports System
Imports System.Text
Imports System.Collections.Generic
Imports Microsoft.VisualStudio.TestTools.UnitTesting
Imports Microsoft.VisualStudio.TeamSystem.Data.UnitTesting
Imports Microsoft.VisualStudio.TeamSystem.Data.UnitTesting.Conditions

<TestClass()> _
Public Class $safeitemname$
    Inherits DatabaseTestClass

    Sub New()
        InitializeComponent()
    End Sub

    <TestInitialize()> _
    Public Sub TestInitialize()
        InitializeTest()
    End Sub

    <TestCleanup()> _
    Public Sub TestCleanup()
        CleanupTest()
    End Sub

    <TestMethod()> _
    Public Sub DatabaseTest1()
        Dim testActions As DatabaseTestActions = Me.DatabaseTest1Data
        '执行预先测试脚本
        '
        System.Diagnostics.Trace.WriteLineIf((Not (testActions.PretestAction) Is Nothing), "正在执行预先测试脚本...")
        Dim pretestResults() As ExecutionResult = TestService.Execute(Me.PrivilegedContext, Me.PrivilegedContext, testActions.PretestAction)
        '执行测试脚本
        '
        System.Diagnostics.Trace.WriteLineIf((Not (testActions.TestAction) Is Nothing), "正在执行测试脚本...")
        Dim testResults() As ExecutionResult = TestService.Execute(Me.ExecutionContext, Me.PrivilegedContext, testActions.TestAction)
        '执行后期测试脚本
        '
        System.Diagnostics.Trace.WriteLineIf((Not (testActions.PosttestAction) Is Nothing), "正在执行后期测试脚本...")
        Dim posttestResults() As ExecutionResult = TestService.Execute(Me.PrivilegedContext, Me.PrivilegedContext, testActions.PosttestAction)
    End Sub

#Region "设计器支持代码"

    '注意: 以下过程是设计器所必需的
    '可以使用设计器修改它。
    '不要使用代码编辑器修改它。
    <System.Diagnostics.DebuggerStepThrough()> _
    Private Sub InitializeComponent()

        Me.DatabaseTest1Data = New Microsoft.VisualStudio.TeamSystem.Data.UnitTesting.DatabaseTestActions
        '
        'DatabaseTest1Data
        '
        Me.DatabaseTest1Data.PosttestAction = Nothing
        Me.DatabaseTest1Data.PretestAction = Nothing
        Me.DatabaseTest1Data.TestAction = Nothing

    End Sub

#End Region

#Region "附加测试属性"
    '
    ' 编写测试时，还可使用以下属性:
    '
    ' 在运行类中的第一个测试之前使用 ClassInitialize 运行代码
    ' <ClassInitialize()> Public Shared Sub MyClassInitialize(ByVal testContext As TestContext)
    ' End Sub
    '
    ' 在类中的所有测试都已运行之后使用 ClassCleanup 运行代码
    ' <ClassCleanup()> Public Shared Sub MyClassCleanup()
    ' End Sub
    '
#End Region

    Private DatabaseTest1Data As DatabaseTestActions
End Class

